# HELM-MAP-SMILES Format Converter CLI

A command-line tool for converting between:

- **MAP format** → **HELM notation**

---

## 📦 Installation & Requirements

### 1. Install Dependencies

Create a virtual environment (recommended):

```bash
python -m venv venv
source venv/bin/activate  # On Windows: venv\Scripts\activate
```

### 2. transfer the files and folder to the virtual environment

### 3. Then install dependencies

```bash
pip install -r requirements.txt
```

### 4. Required Files

Ensure the following file is present in the directory:

- `data/MAP_momomers_lib.csv` – Monomer library mapping MAP to HELM
- `utils.py`

---

## 🚀 Usage

The script is executed via command-line and accepts:

- A single sequence via `--input`
- A file with multiple sequences (`--input`) and optional `--output`

```bash
python converter_cli.py <mode> --input <sequence_or_filepath> [--output <output_file>] [--id <peptide_id>]
```

---

## 🔁 Supported Modes

| Mode          | Description                 | Notes                           |
| ------------- | --------------------------- | ------------------------------- |
| `map_to_helm` | Converts MAP format to HELM | Requires `--id` for peptide IDs |

---

## 🧪 Examples

### 🧬 Single Sequence Conversion

```bash

python converter_cli.py map_to_helm --input "{nnr:Abu}{nnr:Sar}L{nnm:N-Methyl}VL{nnm:N-Methyl}AA{d}L{nnm:N-Methyl}L{nnm:N-Methyl}V{nnm:N-Methyl}{nnr:Mebmt}{cyc:N-C}" --id 1

```

---

### 📁 Batch File Conversion

**Input files should have one sequence per line.**

```bash
# MAP to HELM (IDs required, match the number of lines)
python convert.py --mode map_to_helm --input input_map_ids.txt --output output_helm.txt

📌 Make sure your input file follows this format:
L{d}L{d}LL{d}PY{cyc:N-C},1
LLLL{d}PY{cyc:N-C},2

```

---

## 🧱 File Structure

```
.
├── map_to_helm.py
├── utils.py
├── requirements.txt
├── README.md
└── data/
    └── MAP_momomers_lib.csv
```

---

## 🛠 Dependencies

```
rdkit
pandas
```

Install them using:

```bash
pip install -r requirements.txt
```

## 📬 Contact

For issues or questions, please open an issue or contact the maintainer.
© 2025 HELM-MAP-SMILES Converter Team
