# HELM / MAP / SMILES Format Converter (Streamlit App)

This **Streamlit web app** provides a simple interface to convert peptide sequence formats between:

- **HELM → MAP**

---

## 🚀 Features

- Paste or upload sequences in HELM format
- View conversion results instantly
- Download converted output files
- Includes example sequences for easy testing

---

## 📦 Installation & Requirements

### 1. Create a virtual environment (recommended):

```bash
python -m venv venv
source venv/bin/activate  # On Windows: venv\Scripts\activate
```

### 2. transfer the files and folder to the virtual environment

### 3. Then install dependencies

```bash
pip install -r requirements.txt
```

### 4. Required Files

Ensure the following file is present in the directory:

- `data/MAP_momomers_lib.csv` – Monomer library mapping MAP to HELM
- `utils.py`

## 🧠 How to Run the App

Run the Streamlit application using the following command:

```bash
streamlit run app.py
```

This will open the app in your browser.

---

## 📝 Input Format Examples

### 1️⃣ HELM to MAP

**Input:**

```
PEPTIDE1{[Abu].[Sar].[meL].V.[meL].A.[dA].[meL].[meL].[meV].[Me_Bmt(E)]}$PEPTIDE1,PEPTIDE1,1:R1-11:R2$$$
```

## 📁 Project Structure

```
Format_conversion_app/
├── app.py                # Streamlit app
├── utils.py              # Conversion logic and utilities
├── data/
│   └── MAP_momomers_lib.csv
└── README.md             # This file
```

---

## 🧪 Example Usage

- Navigate to a tab (e.g., "HELM to MAP")
- Paste or load example sequences
- Click "Convert"
- Download the converted output if needed

---

## 📬 Contact

For issues or questions, please open an issue or contact the maintainer.
© 2025 HELM-MAP-SMILES Converter Team
