import argparse
import os
import pandas as pd
import re
from utils import helm_to_map

def main():
    parser = argparse.ArgumentParser(description="HELM to MAP Format Converter")
    parser.add_argument("mode", choices=["helm_to_map"], help="Conversion mode")
    parser.add_argument("--input", required=True, help="Input string or input file path")
    parser.add_argument("--output", help="Output file path (required if input is a file)")

    args = parser.parse_args()
    is_file = os.path.isfile(args.input)

    # Handle HELM to MAP
    if args.mode == "helm_to_map":
        if is_file:
            with open(args.input, "r") as f:
                lines = [line.strip() for line in f if line.strip()]
            results = [helm_to_map(line) for line in lines]
            if not args.output:
                raise ValueError("Output file path required for file input.")
            with open(args.output, "w") as f:
                f.write("\n".join(results))
        else:
            print(helm_to_map(args.input))


if __name__ == "__main__":
    main()