# HELM-MAP-SMILES Format Converter CLI

A command-line tool for converting between:

- **HELM notation** → **MAP format**

---

## 📦 Installation & Requirements

### 1. Install Dependencies

Create a virtual environment (recommended):

```bash
python -m venv venv
source venv/bin/activate  # On Windows: venv\Scripts\activate
```

### 2. transfer the files and folder to the virtual environment

### 3. Then install dependencies

```bash
pip install -r requirements.txt
```

### 4. Required Files

Ensure the following file is present in the directory:

- `data/MAP_momomers_lib.csv` – Monomer library mapping MAP to HELM
- `utils.py`

---

## 🚀 Usage

The script is executed via command-line and accepts:

- A single sequence via `--input`
- A file with multiple sequences (`--input`) and optional `--output`

```bash
python converter_cli.py <mode> --input <sequence_or_filepath> [--output <output_file>] [--id <peptide_id>]
```

---

## 🔁 Supported Modes

| Mode          | Description                     | Notes              |
| ------------- | ------------------------------- | ------------------ |
| `helm_to_map` | Converts a HELM sequence to MAP | Input: HELM format |

---

## 🧪 Examples

### 🧬 Single Sequence Conversion

```bash
python converter_cli.py helm_to_map --input "PEPTIDE1{[Abu].[Sar].[meL].V.[meL].A.[dA].[meL].[meL].[meV].[Me_Bmt(E)]}$PEPTIDE1,PEPTIDE1,1:R1-11:R2$$$"
```

---

### 📁 Batch File Conversion

**Input files should have one sequence per line.**

```bash
# HELM to MAP
python converter_cli.py helm_to_map --input input_helm.txt --output output_map.txt

```

---

## 🧱 File Structure

```
.
├── helm_to_map.py
├── utils.py
├── requirements.txt
├── README.md
└── data/
    └── MAP_momomers_lib.csv
```

---

## 🛠 Dependencies

```
rdkit
pandas
```

Install them using:

```bash
pip install -r requirements.txt
```

---

## 📬 Contact

For issues or questions, please open an issue or contact the maintainer.
© 2025 HELM-MAP-SMILES Converter Team
