#!/usr/bin/python
from __future__ import print_function
import getopt
import sys
import os
import numpy as np
import pandas as pd
import math
import itertools
from itertools import repeat
import argparse
import csv
from collections import Counter
import re
import glob
import time
from time import sleep
from tqdm import tqdm
from argparse import RawTextHelpFormatter
import uuid
import warnings
warnings.filterwarnings("ignore") 
std = list("ACDEFGHIKLMNPQRSTVWY")
PCP= pd.read_csv('Data/PhysicoChemical.csv', header=None)
AAindices = 'Data/aaind.txt'
AAIndex = pd.read_csv('Data/aaindex.csv',index_col='INDEX');
AAIndexNames = pd.read_csv('Data/AAIndexNames.csv',header=None);

parser = argparse.ArgumentParser(description='Please provide following arguments',formatter_class=RawTextHelpFormatter)
## Read Arguments from command
parser.add_argument("-i","-I", "--input", type=str, required=True, help="Input: protein or peptide sequence in FASTA format or single sequence per line in single letter code")
parser.add_argument("-o","-O", "--output",type=str, help="Output: File for saving results by default pfeature_result.csv")
parser.add_argument("-j","-J", "--job",type=str.upper, choices = ['AAB','DPB','ATB','BTB','PCB','AIB','ALLBIN'], help="Job Type:\nAAB: Amino acid based binary profile\nDPB: Dipeptide based binary profile\nATB: Atom based binary profile\nBTB: Bond based binary profile\nPCB: Physico-chemical properties based binary profile\nAIB: Amino-acid indices based binary profile\nALLBIN:All binary profiles together except ATB and BTB\nby default AAB")
parser.add_argument("-n","-N","--n_terminal", type=int, help="Window Length from N-terminal: by default 0")
parser.add_argument("-c","-C","--c_terminal", type=int, help="Window Length from C-terminal: by default 0")
parser.add_argument("-nct","-Nct","-NCt","-NCT","-nCt","-ncT","-nCT","-NcT","--nc_terminal", type=int, help="Residues from N- and C-terminal: by default 0")
parser.add_argument("-rn","-Rn","-RN","-rN","--rest_n", type=int, help="Number of residues removed from N-terminal, by default 0")
parser.add_argument("-rc","-Rc","-RC","-rC","--rest_c", type=int, help="Number of residues removed from C-terminal, by default 0")
parser.add_argument("-rnc","-RNC","-Rnc","-rNc","-rnC","-RNc","-rNC","-RnC","--rest_nc", type=int, help="Number of residues removed from N- and C-terminal, by default 0")
parser.add_argument("-s","-S","--split", type=int, help="Number of splits a sequence divided into, by default 0")
parser.add_argument("-d","-D","--lag", type=int, help="This represents the order of gap, lag or dipeptide, by default 1")
args = parser.parse_args()

#################Amino acid Binary Profile##############################
def aab(file,out):
    filename, file_extension = os.path.splitext(file)
    df = pd.read_csv(file, header = None)
    uu = []
    for ss in df[0]:
         uu.append(len(ss))
    zz = df.iloc[:,0]
    f = open(out, mode='w')
    sys.stdout = f
    A=('1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0')
    C=('0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0')
    D=('0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0')
    E=('0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0')
    F=('0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0')
    G=('0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0')
    H=('0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0')
    I=('0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0')
    K=('0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0')
    L=('0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0')
    M=('0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0')
    N=('0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0')
    P=('0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0')
    Q=('0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0')
    R=('0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0')
    S=('0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0')
    T=('0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0')
    V=('0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0')
    W=('0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0')
    Y=('0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1')
    for mm in range (1,max(uu)+1):
        for ee in std:
            print(ee+str(mm),end=',')
    print("")
    for i in range(0,len(zz)):
        for j in zz[i]:
            if j == "A":
                print(''.join(A), end = ',')
            if j == "C":
                print(''.join(C), end = ',')
            if j == "D":
                print(''.join(D), end = ',')
            if j == "E":
                print(''.join(E), end = ',')
            if j == "F":
                print(''.join(F), end = ',')
            if j == "G":
                print(''.join(G), end = ',')
            if j == "H":
                print(''.join(H), end = ',')
            if j == "I":
                print(''.join(I), end = ',')
            if j == "K":
                print(''.join(K), end = ',')
            if j == "L":
                print(''.join(L), end = ',')
            if j == "M":
                print(''.join(M), end = ',')
            if j == "N":
                print(''.join(N), end = ',')
            if j == "P":
                print(''.join(P), end = ',')
            if j == "Q":
                print(''.join(Q), end = ',')
            if j == "R":
                print(''.join(R), end = ',')
            if j == "S":
                print(''.join(S), end = ',')
            if j == "T":
                print(''.join(T), end = ',')
            if j == "V":
                print(''.join(V), end = ',')
            if j == "W":
                print(''.join(W), end = ',')
            if j == "Y":
                print(''.join(Y), end = ',')
        print("")
    f.truncate()
def aab_split(file,n,out):
    std = list("ACDEFGHIKLMNPQRSTVWY")
    file1 = split(file,n)
    file1.to_csv('sam_input.csv', index=None, header=False)
    aab('sam_input.csv','tempfile_out')
    ff1 = open(out,'w')
    sys.stdout=ff1
    aa = []
    for i in file1[0]:
        aa.append(len(i))
    uu = []
    for i in range(0,len(aa),n):
        uu.append(aa[i:i+n])
    for i in range(1,n+1):
        kk = max(uu)[i-1]
        for j in range(1,kk+1):
            for k in std:
                print(k+str(j)+'_s'+str(i), end=",")
    print("")
    with open("tempfile_out","r") as f:
        fob = f.readlines()
        fob_1 = fob[1:]
    for each in range(0,len(fob_1),n):
        print(','.join(fob_1[each:each+n]).replace(",\n,",",").replace("\n",""))
    ff1.truncate()
    os.remove('sam_input.csv')
    os.remove('tempfile_out')

########################################Dipeptide_binary###############################
def bin_di(file,q,out):
    std = list("ACDEFGHIKLMNPQRSTVWY")
    filename, file_extension = os.path.splitext(file)
    df2=pd.read_csv(file,header=None)
    df = pd.DataFrame(df2[0].str.upper())
    uu = []
    for ss in df[0]:
         uu.append(len(ss))
    mat3 = pd.read_csv("Data/bin_di.csv", header = None)
    mat3.set_index(0, inplace = True)
    mat3.index = pd.Series(mat3.index).replace(np.nan,'NA')
    f = open(out, 'w')
    sys.stdout = f
    for ss in range (1,(max(uu)-q)+1):
        for uu in std:
            for mm in std:
                print(uu+mm+str(ss),end=",")
    print("")
    for i in range(0,len(df)):
        for j in range(0,(len(df[0][i])-(q))):
            temp1 = df[0][i][j:j+q+1:q]
            for each in (mat3.loc[temp1].values.ravel()):
                print("%.0f"%each, end = ",", flush = True)
        print("")
    f.truncate()

def dpb_split(file,n,q,out):
    std = list("ACDEFGHIKLMNPQRSTVWY")
    file1 = split(file,n)
    file1.to_csv('sam_input.csv', index=None, header=False)
    bin_di('sam_input.csv',q,'tempfile_out')
    ff1 = open(out,'w')
    sys.stdout=ff1
    aa = []
    for i in file1[0]:
        aa.append(len(i))
    uu = []
    for i in range(0,len(aa),n):
        uu.append(aa[i:i+n])
    for i in range(1,n+1):
        kk = max(uu)[i-1]
        for j in range(1,(kk+1)-q):
            for k in std:
                for pp in std:
                    print(k+pp+str(j)+'_s'+str(i), end=",")
    print("")
    with open("tempfile_out","r") as f:
        fob = f.readlines()
        fob_1 = fob[1:]
    for each in range(0,len(fob_1),n):
        print(','.join(fob_1[each:each+n]).replace(",\n,",",").replace("\n",""))
    ff1.truncate()
    os.remove('sam_input.csv')
    os.remove('tempfile_out')

#########################################Atomic binary###############################
def atom_bin(file,out) :
    filename, file_extension = os.path.splitext(file)
    df=pd.read_csv(file,header=None)
    ############binary matrix for atoms
    f = open('matrix_atom.out', 'w')
    sys.stdout = f
    print("C,H,N,O,S,")
    x = []
    for i in range(0,5) :
        x.append([])
        for j in range(0,5) :
            if i == j :
                x[i].append(1)
            else :
                x[i].append(0)

            print(x[i][j], end=",")
        print("")
    f.truncate()
##############associate binary values to atoms
    mat = pd.read_csv("matrix_atom.out")
    mat1 = mat.iloc[:,:-1]
    mat2 = mat1.transpose()
    df1 = pd.read_csv("Data/atom.csv",header=None)
    zz = []
    kk = pd.DataFrame()
    df1 = pd.read_csv("Data/atom.csv",header=None)
    for i in range(0,len(df1)) :
        zz.append([])
        for j in range(0,len(df1[1][i])) :
            temp = df1[1][i][j]
            zz[i].append(mat2.loc[temp])

    f1 = open('bin_atom_1', 'w')
    sys.stdout = f1
    for i in range(0,len(zz)) :
        for row in zz[i]:
            print(",".join(map(str,row)), end=",")
        print("")

    f1.truncate()

    with open('bin_atom_1', 'r') as f:
        g = list(f)

    for i in range(0,len(g)) :
        g[i] = g[i].replace(",\n","")

    df1["bin"]=g

    #########binary atom values for given file
    ss =[]
    for i in range(0,len(df)):
        ss.append([])
        for j in df[0][i]:
            for k in range(0,len(df1)):
                if j==df1[0][k]:
                    ss[i].append(df1[1][k])
    uu = []
    for i in range (0,len(ss)):
        uu.append(len("".join(ss[i])))

    xx=[]
    jj = 0
    for i in range(0,len(df)) :
        xx.append([])
        while jj < len(df[0][i]) :
            temp=df[0][i][jj]
            for k in range(0,len(df1)) :
                if temp == df1[0][k][0] :
                    xx[i].append(df1.iloc[k,2])
            jj += 1
        jj = 0


    f2 = open(out, 'w')
    sys.stdout = f2
    for pp in range(1,max(uu)+1):
        for aa in ('C','H','N','O','S'):
            print(aa+str(pp),end=",")
    print("")

    for i in range(0,len(xx)) :
        for row in xx[i]:
            print("".join(map(str,row)), end=",")
        print("")
    f2.truncate()
    os.remove('bin_atom_1')
    os.remove('matrix_atom.out')

def atb_split(file,n,out):
    std_1 = list("CHNOS")
    file1 = split(file,n)
    file1.to_csv('sam_input.csv', index=None, header=False)
    atom_bin('sam_input.csv','tempfile_out')
    df123 = pd.read_csv('tempfile_out')
    df456 = df123.iloc[:,:-1]
    ff1 = open(out,'w')
    sys.stdout=ff1
    aa = []
    for i in range(0,len(df456)):
        aa.append(len(df456.loc[i])/5)
    uu = []
    for i in range(0,len(aa),n):
        uu.append(aa[i:i+n])
    for i in range(1,n+1):
        kk = max(uu)[i-1]
        for j in range(1,int(kk+1)):
            for k in std_1:
                print(k+str(j)+'_s'+str(i), end=",")
    print("")
    with open("tempfile_out","r") as f:
        fob = f.readlines()
        fob_1 = fob[1:]
    for each in range(0,len(fob_1),n):
        print(','.join(fob_1[each:each+n]).replace(",\n,",",").replace("\n",""))
    ff1.truncate()
    os.remove('sam_input.csv')
    os.remove('tempfile_out')

####################################Bonds binary profile########################
def bond_bin(file,out) :
    df=pd.read_csv(file,header=None)
    ############binary matrix for atoms
    f = open('matrix_can_pat.out', 'w')
    sys.stdout = f
    print("-,=,c,b,")
    x = []
    for i in range(0,4) :
        x.append([])
        for j in range(0,4) :
            if i == j :
                x[i].append(1)
            else :
                x[i].append(0)

            print(x[i][j], end=",")
        print("")
    f.truncate()

##############associate binary values to bonds
    mat = pd.read_csv("matrix_can_pat.out")
    mat1 = mat.iloc[:,:-1]
    mat2 = mat1.transpose()
    df1 = pd.read_csv("Data/can_pat.csv")
    zz = []
    kk = pd.DataFrame()

    for i in range(0,len(df1)) :
        zz.append([])
        for j in range(0,len(df1.iloc[:,1][i])) :
            temp = str(df1.iloc[:,1][i][j])
            zz[i].append(mat2.loc[temp])

    f1 = open('bin_bond_1', 'w')
    sys.stdout = f1
    for i in range(0,len(zz)) :
        for row in zz[i]:
            print(",".join(map(str,row)), end=",")
        print("")

    f1.truncate()

    with open('bin_bond_1', 'r') as f:
        g = list(f)

    for i in range(0,len(g)) :
        g[i] = g[i].replace(",\n","")

    df1["bin"] = g


    ss =[]
    for i in range(0,len(df)):
        ss.append([])
        for j in df[0][i]:
            for k in range(0,len(df1)):
                if j==df1['Name'][k]:
                    ss[i].append(df1['canonical_pattern'][k])
    uu = []
    for i in range (0,len(ss)):
        uu.append(len("".join(ss[i])))

    xx=[]
    jj = 0
    for i in range(0,len(df)) :
        xx.append([])
        while jj < len(df[0][i]) :
            temp=df[0][i][jj]
            for k in range(0,len(df1)) :
                if temp == df1.iloc[k,0][0] :
                    xx[i].append(df1.iloc[k,2])
            jj += 1
        jj = 0

    f2 = open(out, 'w')
    sys.stdout = f2
    for pp in range(1,max(uu)+1):
        for aa in ('SI','DO','CY','BE'):
            print(aa+str(pp),end=",")
    print("")
    for i in range(0,len(xx)) :
        for row in xx[i]:
            print("".join(map(str,row)), end=",")
        print("")
    f2.truncate()
    os.remove('matrix_can_pat.out')
    os.remove('bin_bond_1')

def btb_split(file,n,out):
    std_1 = ['SI','DO','CY','BE']
    file1 = split(file,n)
    file1.to_csv('sam_input.csv', index=None, header=False)
    bond_bin('sam_input.csv','tempfile_out')
    df123 = pd.read_csv('tempfile_out')
    df456 = df123.iloc[:,:-1]
    ff1 = open(out,'w')
    sys.stdout=ff1
    aa = []
    for i in range(0,len(df456)):
        aa.append(len(df456.loc[i])/4)
    uu = []
    for i in range(0,len(aa),n):
        uu.append(aa[i:i+n])
    for i in range(1,n+1):
        kk = max(uu)[i-1]
        for j in range(1,int(kk+1)):
            for k in std_1:
                print(k+str(j)+'_s'+str(i), end=",")
    print("")
    with open("tempfile_out","r") as f:
        fob = f.readlines()
        fob_1 = fob[1:]
    for each in range(0,len(fob_1),n):
        print(','.join(fob_1[each:each+n]).replace(",\n,",",").replace("\n",""))
    ff1.truncate()
    os.remove('sam_input.csv')
    os.remove('tempfile_out')
############################################PCP profile##################################
def pcp_bin(file,out):
    df = pd.read_csv(file, header = None)
    uu = []
    for ss in df[0]:
         uu.append(len(ss))
    zz = df.iloc[:,0]
    f = open(out, mode='w')
    sys.stdout = f
    A=('0,0,1,0,1,1,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,1,0')
    C=('0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,1,0,1,0,1,0,0,1,1,0')
    D=('0,1,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1,0,1,0,0,1,0')
    E=('0,1,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,1')
    F=('0,0,1,0,1,0,0,1,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,1')
    G=('0,0,1,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,1,1,0,0,1,1,0')
    H=('1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1')
    I=('0,0,1,0,1,1,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,1')
    K=('1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1')
    L=('0,0,1,0,1,1,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,1')
    M=('0,0,1,0,1,0,0,0,0,0,1,1,0,0,0,1,1,0,0,0,0,1,0,0,1')
    N=('0,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,1,0')
    P=('0,0,1,0,1,1,1,0,0,0,1,1,1,0,0,0,0,0,1,0,1,1,0,1,0')
    Q=('0,0,1,1,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,1,0,0,0,1')
    R=('1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1')
    S=('0,0,1,1,0,0,0,0,0,0,1,0,0,1,1,0,0,0,1,0,0,1,1,1,0')
    T=('0,0,1,1,0,0,0,0,0,0,1,1,0,1,1,0,0,1,0,0,0,1,0,1,0')
    V=('0,0,1,0,1,1,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,1,0')
    W=('0,0,1,0,1,0,0,1,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,1')
    Y=('0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,1,0,0,0,1,0,0,1')
    for mm in range (1,max(uu)+1):
        for ee in ('PC','NC','NE','PO','NP','AL','CY','AR','AC','BS','NE_pH','HB','HL','NT','HX','SC','SS_HE','SS_ST','SS_CO','SA_BU','SA_EX','SA_IN','TN','SM','LR'):
            print(ee+str(mm),end=',')
    print("")
    for i in range(0,len(zz)):
        for j in zz[i]:
            if j == "A":
                print(''.join(A), end = ',')
            if j == "C":
                print(''.join(C), end = ',')
            if j == "D":
                print(''.join(D), end = ',')
            if j == "E":
                print(''.join(E), end = ',')
            if j == "F":
                print(''.join(F), end = ',')
            if j == "G":
                print(''.join(G), end = ',')
            if j == "H":
                print(''.join(H), end = ',')
            if j == "I":
                print(''.join(I), end = ',')
            if j == "K":
                print(''.join(K), end = ',')
            if j == "L":
                print(''.join(L), end = ',')
            if j == "M":
                print(''.join(M), end = ',')
            if j == "N":
                print(''.join(N), end = ',')
            if j == "P":
                print(''.join(P), end = ',')
            if j == "Q":
                print(''.join(Q), end = ',')
            if j == "R":
                print(''.join(R), end = ',')
            if j == "S":
                print(''.join(S), end = ',')
            if j == "T":
                print(''.join(T), end = ',')
            if j == "V":
                print(''.join(V), end = ',')
            if j == "W":
                print(''.join(W), end = ',')
            if j == "Y":
                print(''.join(Y), end = ',')
        print("")
    f.truncate()
def pcb_split(file,n,out):
    std_3 = ['PC','NC','NE','PO','NP','AL','CY','AR','AC','BS','NE_pH','HB','HL','NT','HX','SC','SS_HE','SS_ST','SS_CO','SA_BU','SA_EX','SA_IN','TN','SM','LR']
    file1 = split(file,n)
    file1.to_csv('sam_input.csv', index=None, header=False)
    pcp_bin('sam_input.csv','tempfile_out')
    ff1 = open(out,'w')
    sys.stdout=ff1
    aa = []
    for i in file1[0]:
        aa.append(len(i))
    uu = []
    for i in range(0,len(aa),n):
        uu.append(aa[i:i+n])
    for i in range(1,n+1):
        kk = max(uu)[i-1]
        for j in range(1,kk+1):
            for k in std_3:
                print(k+str(j)+'_s'+str(i), end=",")
    print("")
    with open("tempfile_out","r") as f:
        fob = f.readlines()
        fob_1 = fob[1:]
    for each in range(0,len(fob_1),n):
        print(','.join(fob_1[each:each+n]).replace(",\n,",",").replace("\n",""))
    ff1.truncate()
    os.remove('sam_input.csv')
    os.remove('tempfile_out')
###############################################AAI Index##############################
def aai_bin(file,out):
    filename, file_extension = os.path.splitext(file)
    df = pd.read_csv(file, header = None)
    uu = []
    for ss in df[0]:
         uu.append(len(ss))
    zz = df.iloc[:,0]
    f = open(out, mode='w')
    sys.stdout = f
    A=('0,0,1,1,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,0,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,1,0,1,1,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,0,0,0,0,0,1,0,1,1,1,0,0,1,1,1,1,1,1,1,0,1,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,0,0,0,0,0,1,0,0,0,0,1,1,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,1,0,1,1,0,1,0,1,0,1,1,0,1,1,1,1,1,1,1,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,1,0,0,1,1,1,1,1,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,1,0,1,1,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,1,1,1,1,0,0,0,0,1,1,0,1,1,1,1,1,0,0,1,0,0,1,1,1,0,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,1,1,1,1,0,1,0,0,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,1,0,1,1,1,0,1,0,0,0,0,1,1,1,0,1,1,1,1,0,1,1,0,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,1,0,0,1,1,0,1,1,1,0,1,0,0,0,0,1,1,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0')
    C=('1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,0,0,1,1,0,1,0,0,1,0,1,1,1,0,1,1,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,1,0,0,0,1,1,1,0,1,0,0,1,0,0,0,1,1,0,1,0,1,1,0,1,1,1,1,1,0,1,1,1,1,1,1,1,0,1,1,0,1,1,0,0,0,1,1,0,1,0,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,1,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,1,1,0,1,0,0,0,1,1,0,1,0,1,0,1,1,1,0,0,0,0,0,1,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,1,1,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,0,1,0,0,0,1,0,0,1,0,1,1,0,1,0,1,0,1,1,0,0,1,1,0,0,1,0,1,0,0,0,0,0,0,0,1,1,0,0,0,1,1,1,1,1,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,0,0,0,1,1,1,1,1,0,0,0,0,1,1,0,1,1,1,1,1,0,1,0,0,0,0,1,0,0,1,0,1,1,1,1,1,1,0,1,1,1,0,0,0,1,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,0,1,1,1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,1,1,1,0,1,1,1,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,1,1,0,0,0,0,1,0,1,1,1,1,1,0,1,1,0,1,1,0,1,0,0,0,0,0,1,0,1,0,1,1,1,0,0,0,1,0,1,0,1,0,1,1,0,0,0,1,0,1,0,1,0,0,0,0,1,1,1,1,0,1,0,0,1,1,1,0,1,1,1,0,1,1,1,1,1,1,1,0,1,1,0,0,0,0')
    D=('1,0,0,0,1,1,1,1,1,1,1,0,0,0,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,1,1,1,0,0,0,0,1,0,1,0,1,0,1,1,0,0,1,0,0,1,0,0,0,1,0,0,1,1,0,1,1,0,1,1,0,0,1,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,1,1,0,0,1,0,0,1,0,1,0,1,1,1,0,1,0,0,0,0,0,0,0,0,1,1,1,0,1,1,0,1,1,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,1,0,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,1,1,0,0,0,0,0,1,0,1,1,1,1,0,1,0,1,0,0,0,0,1,1,1,0,0,1,0,0,0,0,1,1,1,0,0,0,1,0,0,1,1,0,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,1,1,1,1,1,0,1,1,1,1,0,0,0,1,0,1,0,0,0,0,1,0,1,1,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,0,0,0,1,1,1,1,1,1,1,1,0,1,1,1,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,0,0,0,0,0,0,1,1,1,1,1,1,0,1,0,1,0,1,0,0,0,1,1,0,1,0,0,0,0,1,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,0,0,1,1,1,1,1,1,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,1,1,1,1,0,1,1,0,1,1,1,1,1,0,1,0,0,0,0,1,1,1,0,0,0,1,1,1,0,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,0,1,1,0,0,0,1,1,1,0,0,0,0,0,0,1,0,0,0,1,1,0,1,1,1,0,1,1,1,0,0,1,0,0,1,0,1,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,0,0,1,1,0,0,0,0,0,0,1,0,0')
    E=('0,0,0,0,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,1,0,1,0,1,1,0,0,1,1,0,1,1,1,0,1,0,0,0,1,1,1,1,0,1,1,1,0,0,0,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,0,0,1,0,0,1,0,1,1,0,1,1,0,1,0,0,1,1,1,0,0,0,1,1,1,0,1,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,1,1,0,1,0,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,0,1,1,1,0,0,0,1,1,0,0,1,1,1,1,0,1,1,0,0,1,1,0,1,0,0,1,1,0,0,1,0,1,0,0,0,1,1,0,1,1,0,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,1,1,1,1,1,0,0,1,1,1,0,1,0,0,1,0,1,1,0,1,0,0,0,0,0,1,0,0,0,1,1,0,0,0,0,0,1,1,0,1,0,1,1,1,1,1,1,1,0,0,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,1,0,0,0,0,0,1,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,1,0,1,1,1,0,0,0,1,0,1,1,0,0,0,0,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,1,0,0,0,1,1,1,1,1,0,1,0,0,1,0,0,0,0,1,0,1,0,0,1,1,0,0,0,1,1,0,0,0,0,0,0,1,0,0')
    F=('1,1,1,1,1,1,0,0,1,0,0,1,1,0,1,0,1,1,0,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,1,1,1,1,0,0,1,0,0,1,0,0,1,1,1,0,0,0,1,1,1,0,1,1,1,0,1,1,0,1,1,0,0,1,0,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,0,0,1,1,0,1,1,0,1,0,1,1,0,0,1,0,1,1,1,1,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,1,1,0,0,0,0,1,1,0,0,0,1,1,1,0,1,0,0,1,1,1,0,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,0,0,1,1,0,1,1,0,0,0,0,0,0,1,0,1,0,1,1,1,0,0,0,0,0,1,1,1,1,1,0,0,1,0,1,1,1,1,1,1,1,1,0,1,0,1,1,1,1,1,0,1,1,1,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,1,1,0,1,1,1,1,1,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,0,0,1,0,1,0,0,0,0,0,0,0,0,1,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,0,1,1,1,1,1,1,0,0,1,0,0,0,1,0,1,0,0,1,1,1,1,0,0,0,1,0,1,1,1,1,0,0,1,0,0,0,1,1,1,1,1,1,0,1,1,1,1,0,0,1,0,1,1,0,1,1,0,0,1,1,0,1,1,1,1,1,1,1,0,1,1,0,0,0,1,1,1,1,1,1,0,1,0,0,1,1,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,1,1,1,1,0,1,1,0,0,1,1,0,1,1,1,1,1,1,1,0,0,0,0,1,0,1,1,1,1,0,0,0,0,1,1,0,1,1,1,1,1,0,1,0,1,0,0,1,1,1,0,0,1,1,1,0,1,1,1,0,1,1,1,1,0,1,0,1,0,0,1,0,0,1,1,0,0,1,1,1,0,0,0,0,0,1,0,1,0,1,1,1,1,0,1,1,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1')
    G=('0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,1,1,1,1,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,1,1,0,0,1,0,0,1,1,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,1,0,1,0,1,1,1,1,0,0,1,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,1,1,0,0,1,1,0,1,0,1,1,0,1,1,0,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,1,1,1,1,1,0,0,1,1,0,0,1,0,1,0,0,1,0,0,0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,0,1,0,1,1,1,0,1,1,1,1,1,1,1,1,1,0,0,0,1,0,1,0,0,1,1,1,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,1,0,0,0,0,0,1,1,1,0,0,0,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,1,1,1,1,1,0,1,0,1,1,1,1,1,1,1,0,1,0,1,1,1,1,0,1,0,0,1,1,0,1,1,0,1,1,1,1,0,1,1,1,0,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,1,1,1,1,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,0,1,1,0,1,0,1,1,0,0,0,0,0,0,0,0,1,1,1,0,1,1,0,1,1,1,0,0,0,0,1,1,1,1,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0')
    H=('1,0,0,0,1,1,1,0,0,0,1,0,0,0,0,0,0,0,0,1,1,1,0,1,1,0,0,0,1,1,1,0,1,1,1,1,0,0,0,1,0,1,1,1,1,0,1,0,0,0,0,0,1,1,0,1,1,0,1,1,1,0,1,1,1,0,0,0,0,1,0,0,0,1,1,1,0,0,0,0,1,0,1,0,0,1,1,1,0,1,0,0,0,0,0,1,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,0,0,1,1,1,0,0,0,0,0,1,0,1,1,0,1,0,1,1,0,1,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,0,0,0,0,1,0,1,1,0,1,0,1,1,0,1,0,1,1,0,0,0,1,1,1,1,0,1,1,1,1,1,0,0,1,1,0,0,0,1,0,1,0,1,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,1,1,1,1,1,1,1,1,0,1,0,1,1,1,1,1,0,0,0,1,0,1,1,0,0,0,1,0,1,0,1,1,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,1,0,0,0,0,0,1,0,0,1,1,0,0,0,1,0,0,0,0,0,0,1,1,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,1,0,1,0,1,1,0,0,0,0,1,1,0,1,1,1,0,0,1,0,1,0,0,0,1,1,0,0,0,1,1,0,0,0,0,1,1,1,1,1,0,0,0,0,1,0,1,0,0,0,0,1,1,1,1,1,1,1,1,1,0,1,0,0,0,1,1,1,1,0,1,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,1,1,0,0,0,0,1,1,0,1,0,0,0,1,0,1,1,1,1,0,0,0,1,0,0,1,1,1,1,1,1,1,0,1,0,1,1,0,0,1,0,1,0,0,1,0,1,1,1,1,1,1,0,0,0,1,1,0,0,1,0,1,1,1,0,0,1,1,1,1,0,1,1,1,1,0,0,0,0,1,0,0,0,0,1,1,1,1,0,0,0,0,1,0,0,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,0')
    I=('0,1,1,1,1,0,0,0,0,1,0,1,1,1,1,1,1,1,0,0,0,1,0,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,0,1,1,0,1,1,1,1,0,1,1,1,0,1,1,1,0,1,1,1,0,0,0,0,1,1,0,1,1,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,1,0,1,0,1,1,1,0,1,1,0,1,0,0,1,1,1,1,0,1,1,1,1,0,1,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,0,0,1,1,1,1,1,0,0,0,0,0,0,1,0,1,0,1,1,1,1,1,1,1,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,0,0,1,0,0,1,1,0,1,0,0,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,0,1,1,1,1,1,1,0,0,1,0,0,1,1,0,1,0,0,0,1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,0,1,1,1,1,0,0,1,0,0,1,0,1,1,0,0,0,1,0,1,0,1,1,0,1,0,1,0,1,0,0,0,1,1,1,1,1,1,1,0,0,0,1,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,1,0,1,1,0,0,1,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,1,0,1,0,1,1,1,1,0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,0,0,1,1,0,1,1,1,1,1,0,0,0,0,1,0,0,1,1,1,0,1,0,1,0,0,0,0,0,1,0,1,1,0,1,1,1,1,1,1,0,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1')
    K=('0,1,0,0,1,1,0,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,1,1,1,0,0,1,0,0,0,1,1,1,0,1,1,0,0,1,1,0,1,1,1,1,0,0,0,0,1,1,1,0,1,1,1,1,0,0,1,1,0,1,0,1,1,1,0,0,1,0,0,1,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,1,1,1,0,0,0,1,0,0,1,0,1,1,0,1,0,1,1,0,0,1,1,1,0,1,0,0,1,0,1,0,1,1,0,0,1,1,0,1,1,1,1,0,0,0,0,1,1,1,1,0,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,1,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,1,0,1,0,1,0,1,0,0,1,1,1,0,1,1,0,1,0,1,0,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,1,1,1,1,1,0,0,1,1,0,0,1,1,1,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,0,1,0,1,1,0,1,1,0,1,0,0,0,0,0,1,0,0,1,1,1,1,0,0,0,0,1,1,0,1,0,1,1,1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,0,0,0,0,0,0,1,0,1,1,1,1,1,1,0,0,0,1,1,1,0,0,0,0,1,1,1,0,0,0,1,0,1,0,1,1,1,0,1,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,1,1,0,1,1,1,1,0,0,1,0,1,1,1,1,1,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,0,0,1,1,1,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,0,0,0,0,1,1,1,0,1,1,1,1,1,1,1,0,1,1,0,0,0,1,0,1,1,0,1,0,0,0,1,1,0,1,1,0,1,0,1,0,0,0,1,1,1,0,1,0,1,1,0,1,1,1,1,0,1,0,0,0,1,1,1,1,1,0,1,0,1,0,0,0,0,0,1,0,1,0,0,1,1,0,0,1,1,1,1,0,0,0,1,1,1,1,0')
    L=('0,1,1,1,0,0,0,1,0,0,0,1,1,1,1,1,1,1,1,1,0,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0,0,0,0,1,0,0,1,1,0,1,1,0,0,1,0,0,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,0,1,1,0,1,1,1,1,1,0,1,0,0,1,0,1,1,0,1,1,1,1,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,1,1,1,0,1,0,1,1,0,0,1,1,0,0,0,0,1,0,0,1,1,1,1,0,0,0,0,1,1,0,1,0,1,0,1,1,1,1,1,0,1,1,1,1,1,1,1,0,0,1,0,0,0,0,1,0,0,1,1,0,1,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,0,0,1,0,0,1,1,1,1,0,1,1,0,0,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,0,1,0,0,1,1,1,1,0,0,1,1,1,0,0,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,1,0,1,1,1,1,0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,0,0,1,0,0,0,0,0,1,0,1,0,0,1,1,1,0,0,1,0,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1')
    M=('1,1,1,1,0,1,0,1,1,0,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,1,1,1,0,1,1,1,0,0,0,0,0,1,1,0,0,0,0,1,1,1,0,1,1,1,0,1,1,0,1,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,0,1,0,1,1,1,0,1,1,1,1,0,1,1,1,0,1,0,1,1,1,1,1,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,0,0,0,0,0,1,0,1,1,1,1,0,1,0,1,1,0,0,1,1,0,0,0,0,1,0,0,1,1,0,1,1,0,0,0,0,0,0,1,0,1,0,1,1,1,1,0,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,0,1,1,0,1,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,1,1,0,1,1,1,1,0,0,1,0,0,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,0,1,0,1,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,1,0,1,0,0,1,1,0,0,0,0,1,0,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,1,0,1,0,1,1,0,0,0,1,1,0,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,0,1,1,1,1,0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,0,0,1,1,1,1,1,1,1,0,1,0,0,0,0,0,1,0,1,1,1,1,0,1,0,0,0,0,0,1,1,0,1,0,1,1,0,0,1,0,1,0,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1')
    N=('1,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,1,1,1,0,0,0,0,0,0,0,0,1,0,0,1,1,0,1,0,0,1,1,0,0,1,0,0,1,0,0,1,0,0,1,1,0,1,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,1,0,1,1,1,0,0,0,0,1,0,1,0,1,0,1,1,1,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,1,1,1,1,0,1,1,0,0,0,0,0,1,1,1,0,0,1,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,1,1,0,0,0,1,0,0,1,1,0,1,1,1,0,1,0,0,1,1,1,0,0,0,1,1,0,1,1,1,1,1,0,1,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,1,0,0,1,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,1,1,1,1,1,1,1,0,1,1,1,1,0,0,0,0,1,1,1,0,0,0,1,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,0,0,1,0,1,1,1,0,0,1,1,0,1,1,0,1,1,0,0,1,0,0,0,1,0,0,0,0,0,1,1,1,0,0,0,0,1,0,0,0,0,0,1,1,0,1,0,1,0,0,0,0,0,1,1,1,0,1,1,0,0,0,1,1,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,0,1,0,0,1,1,1,1,1,0,1,0,1,1,0,0,0,0,1,0,1,0,0,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0')
    P=('1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,0,1,0,1,0,0,1,0,0,1,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,1,0,1,1,0,0,1,1,1,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,1,0,0,1,1,1,0,0,0,0,1,1,0,1,0,0,0,0,1,0,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,0,0,0,0,1,1,1,1,0,0,1,0,0,0,0,1,1,1,0,1,0,0,1,1,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,0,1,1,0,1,1,1,0,0,0,0,0,0,1,1,1,1,0,1,0,0,0,1,1,1,0,0,0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,1,0,0,1,1,0,0,0,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,1,1,1,1,0,1,0,0,0,0,0,0,0,1,1,0,1,1,1,0,1,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,0,1,1,1,0,1,1,1,0,1,1,1,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,0,0,1,1,1,1,0,1,1,0,0,0,0,0,1,1,0,1,0,0,0,1,0,0,1,0,1,1,1,0,0,0,0,0,1,0,0,0,1,1,0,0,1,1,1,1,1,1,1,0,0,1,0,0,0,1,0,0,0,1,1,0,1,1,0,0,1,1,0,0,0,0,1,1,0,1,1')
    Q=('0,0,0,0,0,0,0,1,1,1,1,1,1,0,1,1,0,1,1,1,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,0,0,0,1,0,1,0,1,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,0,1,1,1,1,0,0,0,1,1,0,1,1,0,0,1,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,1,0,1,0,0,0,0,0,1,0,1,1,0,1,0,1,1,0,0,1,1,1,0,0,0,1,1,1,0,0,1,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,0,0,1,0,0,1,1,0,1,0,1,1,1,0,0,1,1,1,1,0,1,1,1,1,1,0,1,1,0,1,1,0,0,0,0,1,0,1,0,1,0,1,0,0,0,1,0,1,0,0,0,1,0,1,0,1,1,0,1,1,1,0,1,1,1,1,1,0,1,0,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,0,1,0,0,1,0,1,1,0,0,0,0,0,1,0,1,0,0,1,0,1,0,0,0,0,0,1,1,0,1,0,1,1,1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,1,1,1,1,0,0,1,0,1,0,1,1,1,0,1,0,0,1,1,1,0,0,1,1,1,0,1,1,1,0,1,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,1,1,0,1,1,1,0,0,1,0,1,1,1,1,1,1,0,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,1,1,0,1,1,1,1,1,1,1,1,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,1,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,0,1,1,1,1,1,1,0,0,1,0,1,0,0,0,1,1,1,0,1,0,0,0,1,1,0,0,0,1,1,1,1,0,1,1,0,0,1,1,1,1,0,0,1,0,1,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0')
    R=('0,0,0,0,1,1,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,0,1,1,0,0,0,0,0,0,1,1,1,0,0,1,0,0,1,1,1,1,0,1,0,1,0,0,0,0,0,1,1,1,0,1,1,0,1,1,1,0,1,1,1,1,0,0,0,0,0,1,0,1,0,1,0,0,0,1,0,1,1,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,1,0,0,1,1,1,0,1,1,0,0,1,1,0,1,1,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,1,1,0,1,0,0,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,0,1,1,1,1,1,1,1,0,1,1,1,0,1,1,0,1,1,0,0,1,0,1,0,0,0,0,1,1,0,0,0,0,0,1,0,1,1,0,1,1,1,1,1,1,1,0,1,0,1,0,1,1,1,1,1,0,0,1,1,1,1,1,0,1,0,1,1,1,1,1,1,0,0,1,0,0,0,1,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,1,1,0,1,0,1,1,1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,1,0,1,1,0,0,0,0,0,0,1,1,0,1,1,0,0,0,0,0,1,1,0,1,0,1,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,0,0,0,1,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,0,1,1,1,0,0,1,1,1,1,1,1,0,1,1,0,1,0,1,0,1,1,0,0,0,0,1,0,1,0,0,0,0,1,1,1,0,0,1,1,1,0,0,1,1,1,1,0,1,0,1,1,1,1,1,0,1,0,1,0,0,0,1,0,1,0,1,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,1,1,0')
    S=('1,0,1,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,1,1,1,0,1,0,1,1,1,1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,1,1,0,1,1,0,0,0,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,0,1,0,0,0,1,1,1,0,0,1,1,0,1,1,1,0,0,0,0,0,1,0,0,1,1,1,1,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,0,0,0,0,1,1,1,1,1,0,1,1,0,0,0,0,1,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,0,1,0,1,0,0,0,1,0,1,0,1,1,1,1,0,1,1,1,1,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,1,0,0,0,0,0,1,0,0,1,1,0,0,0,0,0,1,1,0,0,0,1,1,1,1,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,1,1,0,1,1,1,1,0,1,1,1,0,0,0,0,1,0,1,0,1,1,1,0,0,0,1,1,0,0,1,0,1,1,0,1,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,0,0,0,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,0,0,0,1,1,1,1,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1,1,1,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,1,1,0,0,1,1,0,1,0,0,0,0,0,0,0,1,1,1,1,0,1,1,1,0,0,0,1,0,1,0,0,1,1,1,1,0,1,0,1,1,1,0,0,1,1,0,1,0,0,1,0,1,0,1,1,1,0,0,0,0,0,0,0,0,0')
    T=('0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,0,0,0,1,0,1,0,1,0,1,0,1,1,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0,0,1,0,0,0,0,1,0,1,0,1,0,1,0,1,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,1,1,1,1,0,0,0,0,1,0,0,0,0,0,0,1,0,1,0,0,0,1,0,1,0,1,1,0,0,0,0,1,0,0,0,0,0,1,1,1,0,1,1,1,0,1,1,1,0,0,1,0,0,1,1,1,1,0,0,1,1,1,1,1,0,0,1,0,1,0,0,1,1,0,0,1,1,1,0,0,0,0,0,0,0,0,1,1,1,0,0,1,0,1,0,0,0,0,0,0,1,1,1,1,1,0,0,1,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,1,0,0,1,0,1,1,0,0,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,1,1,1,1,0,1,0,0,1,0,0,0,1,0,1,0,0,0,1,1,0,0,0,1,1,1,1,1,0,0,1,1,0,0,0,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,0,1,0,1,1,0,0,0,1,1,0,1,1,0,0,0,0,0,0,1,0,0,1,1,1,1,1,0,0,1,0,0,1,1,1,0,1,0,0,1,0,1,0,1,0,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,0,1,1,1,1,0,0,0,1,1,0,1,0,1,1,0,0,1,0,1,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,1,1,0,1,0,1,1,1,1,0,0,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,1,1,1,0,1,0,1,0,1,0,0,0,1,0,1,0,0,1,1,1,0,0,1,0,1,1,1,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0')
    V=('0,1,1,1,0,0,0,0,0,0,0,1,1,0,1,0,0,1,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,0,0,1,1,0,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,1,1,0,0,1,0,0,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,1,0,0,1,1,1,1,1,1,1,0,1,0,0,1,1,1,1,0,1,1,1,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,0,0,1,1,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,1,0,1,1,1,1,1,1,1,1,1,0,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,1,0,0,1,0,0,1,0,0,1,1,1,1,0,1,0,0,0,0,0,1,1,1,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,1,0,1,0,1,0,0,0,1,0,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,1,1,1,1,1,0,0,0,1,1,1,0,0,1,1,0,1,1,1,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,1,0,0,0,0,1,1,1,1,1,1,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,1,1,1,1,1,0,1,1,0,0,0,1,0,1,1,0,1,0,1,1,0,0,0,0,0,1,0,1,1,1,1,1,0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,0,0,1,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,0,0,0,0,1,1,1,0,0,1,1,1,0,1,0,0,1,1,0,0,0,1,1,1,1,0,1,1,1,1,1,0,0,1')
    W=('1,1,0,1,0,0,1,0,0,1,1,1,1,0,0,1,1,0,1,0,0,1,0,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,1,1,1,0,1,0,1,0,0,0,0,0,1,1,1,0,1,0,1,1,1,0,1,1,1,0,0,0,0,1,1,0,1,0,0,0,1,1,0,1,0,0,0,1,0,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,1,1,0,0,0,1,0,1,1,0,1,0,1,1,0,1,1,0,1,1,1,1,1,0,1,1,0,1,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,0,0,1,1,1,1,1,0,0,0,1,1,0,1,0,1,0,1,1,1,1,0,0,0,0,1,0,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,0,1,0,1,1,1,1,1,0,1,1,1,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,1,0,1,1,0,1,1,1,0,1,0,0,1,0,1,1,0,1,1,0,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,1,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,1,1,1,0,1,0,0,1,0,0,0,1,0,1,0,0,1,1,1,1,0,0,1,0,1,1,1,1,0,1,1,0,0,0,0,1,1,1,1,1,0,0,0,1,1,1,0,0,1,0,0,1,0,1,1,0,0,0,1,0,1,1,1,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,0,0,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,1,0,1,0,1,1,0,1,1,0,1,0,1,1,1,1,1,0,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,0,1,0,0,1,0,1,0,1,1,1,1,1,1,1,0,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,0,1,0,0,1,0,0,1,1,0,0,1,1,1,0,0,0,0,0,1,0,1,0,0,0,1,1,1,1,1,0,0,0,0,1,1,1,0,1,0,1,1,1,1,0,1,0,0,1')
    Y=('1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,0,0,1,0,1,0,0,1,1,1,1,0,1,1,0,1,1,1,1,1,1,1,0,1,1,1,1,0,1,1,0,0,0,0,0,1,1,1,1,1,0,1,1,1,0,1,1,1,1,0,0,1,0,1,1,0,0,1,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,1,1,0,1,1,1,0,0,1,0,0,1,1,0,0,0,1,1,1,0,1,0,1,1,1,1,0,0,1,1,0,1,1,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,1,0,1,1,1,0,1,0,1,1,0,1,1,0,1,0,1,0,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,1,0,1,1,0,1,0,0,0,1,1,0,1,0,0,1,1,0,0,0,0,0,0,1,0,1,0,0,0,0,1,1,1,1,1,1,1,1,0,1,0,1,1,1,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,1,1,1,0,1,1,0,1,0,1,1,1,1,1,0,1,1,1,0,0,1,1,1,1,1,0,1,0,1,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,0,0,1,1,0,0,0,1,0,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,0,1,1,0,0,0,1,0,0,1,0,0,0,1,1,1,1,0,0,0,1,1,1,1,0,1,1,0,0,0,1,1,1,1,1,0,1,0,0,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,1,1,1,1,1,0,1,0,1,1,1,1,1,0,0,0,0,0,1,0,1,0,0,1,1,1,0,1,1,1,0,1,0,1,0,1,0,1,1,1,1,0,1,0,1,0,1,1,1,0,1,0,1,0,0,0,1,0,1,0,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,1,1,1,1,0,1,1,1,0,0,1,1,1,1,1,1,1,0,0,1,0,1,1,0,0,0,1,1,1,0,0,1,1,1,0,0,0,0,0,0,0,1,0,1,0,1,1,1,0,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1')
    for mm in range (1,max(uu)+1):
        for ee in ('ANDN920101','ARGP820101','ARGP820102','ARGP820103','AURR980101','AURR980102','AURR980103','AURR980104','AURR980105','AURR980106','AURR980107','AURR980108','AURR980109','AURR980110','AURR980111','AURR980112','AURR980113','AURR980114','AURR980115','AURR980116','AURR980117','AURR980118','AURR980119','AURR980120','BAEK050101','BASU050101','BASU050102','BASU050103','BEGF750101','BEGF750102','BEGF750103','BHAR880101','BIGC670101','BIOV880101','BIOV880102','BLAM930101','BLAS910101','BROC820101','BROC820102','BULH740101','BULH740102','BUNA790101','BUNA790102','BUNA790103','BURA740101','BURA740102','CASG920101','CEDJ970101','CEDJ970102','CEDJ970103','CEDJ970104','CEDJ970105','CHAM810101','CHAM820101','CHAM820102','CHAM830101','CHAM830102','CHAM830103','CHAM830104','CHAM830105','CHAM830106','CHAM830107','CHAM830108','CHOC750101','CHOC760101','CHOC760102','CHOC760103','CHOC760104','CHOP780101','CHOP780201','CHOP780202','CHOP780203','CHOP780204','CHOP780205','CHOP780206','CHOP780207','CHOP780208','CHOP780209','CHOP780210','CHOP780211','CHOP780212','CHOP780213','CHOP780214','CHOP780215','CHOP780216','CIDH920101','CIDH920102','CIDH920103','CIDH920104','CIDH920105','COHE430101','CORJ870101','CORJ870102','CORJ870103','CORJ870104','CORJ870105','CORJ870106','CORJ870107','CORJ870108','COSI940101','COWR900101','CRAJ730101','CRAJ730102','CRAJ730103','DAWD720101','DAYM780101','DAYM780201','DESM900101','DESM900102','DIGM050101','EISD840101','EISD860101','EISD860102','EISD860103','ENGD860101','FASG760101','FASG760102','FASG760103','FASG760104','FASG760105','FASG890101','FAUJ830101','FAUJ880101','FAUJ880102','FAUJ880103','FAUJ880104','FAUJ880105','FAUJ880106','FAUJ880107','FAUJ880108','FAUJ880109','FAUJ880110','FAUJ880111','FAUJ880112','FAUJ880113','FINA770101','FINA910101','FINA910102','FINA910103','FINA910104','FODM020101','FUKS010101','FUKS010102','FUKS010103','FUKS010104','FUKS010105','FUKS010106','FUKS010107','FUKS010108','FUKS010109','FUKS010110','FUKS010111','FUKS010112','GARJ730101','GEIM800101','GEIM800102','GEIM800103','GEIM800104','GEIM800105','GEIM800106','GEIM800107','GEIM800108','GEIM800109','GEIM800110','GEIM800111','GEOR030101','GEOR030102','GEOR030103','GEOR030104','GEOR030105','GEOR030106','GEOR030107','GEOR030108','GEOR030109','GOLD730101','GOLD730102','GRAR740101','GRAR740102','GRAR740103','GUOD860101','GUYH850101','GUYH850102','GUYH850104','GUYH850105','HARY940101','HOPA770101','HOPT810101','HUTJ700101','HUTJ700102','HUTJ700103','ISOY800101','ISOY800102','ISOY800103','ISOY800104','ISOY800105','ISOY800106','ISOY800107','ISOY800108','JACR890101','JANJ780101','JANJ780102','JANJ780103','JANJ790101','JANJ790102','JOND750101','JOND750102','JOND920101','JOND920102','JUKT750101','JUNJ780101','JURD980101','KANM800101','KANM800102','KANM800103','KANM800104','KARP850101','KARP850102','KARP850103','KARS160101','KARS160102','KARS160103','KARS160104','KARS160105','KARS160106','KARS160107','KARS160108','KARS160109','KARS160110','KARS160111','KARS160112','KARS160113','KARS160114','KARS160115','KARS160116','KARS160117','KARS160118','KARS160119','KARS160120','KARS160121','KARS160122','KHAG800101','KIDA850101','KIMC930101','KLEP840101','KOEP990101','KOEP990102','KRIW710101','KRIW790101','KRIW790102','KRIW790103','KUHL950101','KUMS000101','KUMS000102','KUMS000103','KUMS000104','KYTJ820101','LAWE840101','LEVM760101','LEVM760102','LEVM760103','LEVM760104','LEVM760105','LEVM760106','LEVM760107','LEVM780101','LEVM780102','LEVM780103','LEVM780104','LEVM780105','LEVM780106','LEWP710101','LIFS790101','LIFS790102','LIFS790103','MANP780101','MAXF760101','MAXF760102','MAXF760103','MAXF760104','MAXF760105','MAXF760106','MCMT640101','MEEJ800101','MEEJ800102','MEEJ810101','MEEJ810102','MEIH800101','MEIH800102','MEIH800103','MITS020101','MIYS850101','MIYS990101','MIYS990102','MIYS990103','MIYS990104','MIYS990105','MONM990101','MONM990201','MUNV940101','MUNV940102','MUNV940103','MUNV940104','MUNV940105','NADH010101','NADH010102','NADH010103','NADH010104','NADH010105','NADH010106','NADH010107','NAGK730101','NAGK730102','NAGK730103','NAKH900101','NAKH900102','NAKH900103','NAKH900104','NAKH900105','NAKH900106','NAKH900107','NAKH900108','NAKH900109','NAKH900110','NAKH900111','NAKH900112','NAKH900113','NAKH920101','NAKH920102','NAKH920103','NAKH920104','NAKH920105','NAKH920106','NAKH920107','NAKH920108','NISK800101','NISK860101','NOZY710101','OLSK800101','ONEK900101','ONEK900102','OOBM770101','OOBM770102','OOBM770103','OOBM770104','OOBM770105','OOBM850101','OOBM850102','OOBM850103','OOBM850104','OOBM850105','PALJ810101','PALJ810102','PALJ810103','PALJ810104','PALJ810105','PALJ810106','PALJ810107','PALJ810108','PALJ810109','PALJ810110','PALJ810111','PALJ810112','PALJ810113','PALJ810114','PALJ810115','PALJ810116','PARJ860101','PARS000101','PARS000102','PLIV810101','PONJ960101','PONP800101','PONP800102','PONP800103','PONP800104','PONP800105','PONP800106','PONP800107','PONP800108','PONP930101','PRAM820101','PRAM820102','PRAM820103','PRAM900101','PRAM900102','PRAM900103','PRAM900104','PTIO830101','PTIO830102','PUNT030101','PUNT030102','QIAN880101','QIAN880102','QIAN880103','QIAN880104','QIAN880105','QIAN880106','QIAN880107','QIAN880108','QIAN880109','QIAN880110','QIAN880111','QIAN880112','QIAN880113','QIAN880114','QIAN880115','QIAN880116','QIAN880117','QIAN880118','QIAN880119','QIAN880120','QIAN880121','QIAN880122','QIAN880123','QIAN880124','QIAN880125','QIAN880126','QIAN880127','QIAN880128','QIAN880129','QIAN880130','QIAN880131','QIAN880132','QIAN880133','QIAN880134','QIAN880135','QIAN880136','QIAN880137','QIAN880138','QIAN880139','RACS770101','RACS770102','RACS770103','RACS820101','RACS820102','RACS820103','RACS820104','RACS820105','RACS820106','RACS820107','RACS820108','RACS820109','RACS820110','RACS820111','RACS820112','RACS820113','RACS820114','RADA880101','RADA880102','RADA880103','RADA880104','RADA880105','RADA880106','RADA880107','RADA880108','RICJ880101','RICJ880102','RICJ880103','RICJ880104','RICJ880105','RICJ880106','RICJ880107','RICJ880108','RICJ880109','RICJ880110','RICJ880111','RICJ880112','RICJ880113','RICJ880114','RICJ880115','RICJ880116','RICJ880117','ROBB760101','ROBB760102','ROBB760103','ROBB760104','ROBB760105','ROBB760106','ROBB760107','ROBB760108','ROBB760109','ROBB760110','ROBB760111','ROBB760112','ROBB760113','ROBB790101','ROSG850101','ROSG850102','ROSM880101','ROSM880102','ROSM880103','SIMZ760101','SNEP660101','SNEP660102','SNEP660103','SNEP660104','SUEM840101','SUEM840102','SUYM030101','SWER830101','TAKK010101','TANS770101','TANS770102','TANS770103','TANS770104','TANS770105','TANS770106','TANS770107','TANS770108','TANS770109','TANS770110','TSAJ990101','TSAJ990102','VASM830101','VASM830102','VASM830103','VELV850101','VENT840101','VHEG790101','VINM940101','VINM940102','VINM940103','VINM940104','WARP780101','WEBA780101','WERD780101','WERD780102','WERD780103','WERD780104','WILM950101','WILM950102','WILM950103','WILM950104','WIMW960101','WOEC730101','WOLR790101','WOLR810101','WOLS870101','WOLS870102','WOLS870103','YUTK870101','YUTK870102','YUTK870103','YUTK870104','ZASB820101','ZHOH040101','ZHOH040102','ZHOH040103','ZIMJ680101','ZIMJ680102','ZIMJ680103','ZIMJ680104','ZIMJ680105'):
            print(ee+'_'+str(mm),end=',')
    print("")
    for i in range(0,len(zz)):
        for j in zz[i]:
            if j == "A":
                print(''.join(A), end = ',')
            if j == "C":
                print(''.join(C), end = ',')
            if j == "D":
                print(''.join(D), end = ',')
            if j == "E":
                print(''.join(E), end = ',')
            if j == "F":
                print(''.join(F), end = ',')
            if j == "G":
                print(''.join(G), end = ',')
            if j == "H":
                print(''.join(H), end = ',')
            if j == "I":
                print(''.join(I), end = ',')
            if j == "K":
                print(''.join(K), end = ',')
            if j == "L":
                print(''.join(L), end = ',')
            if j == "M":
                print(''.join(M), end = ',')
            if j == "N":
                print(''.join(N), end = ',')
            if j == "P":
                print(''.join(P), end = ',')
            if j == "Q":
                print(''.join(Q), end = ',')
            if j == "R":
                print(''.join(R), end = ',')
            if j == "S":
                print(''.join(S), end = ',')
            if j == "T":
                print(''.join(T), end = ',')
            if j == "V":
                print(''.join(V), end = ',')
            if j == "W":
                print(''.join(W), end = ',')
            if j == "Y":
                print(''.join(Y), end = ',')
        print("")
    f.truncate()
def aib_split(file,n,out):
    std_3 = ['ANDN920101','ARGP820101','ARGP820102','ARGP820103','AURR980101','AURR980102','AURR980103','AURR980104','AURR980105','AURR980106','AURR980107','AURR980108','AURR980109','AURR980110','AURR980111','AURR980112','AURR980113','AURR980114','AURR980115','AURR980116','AURR980117','AURR980118','AURR980119','AURR980120','BAEK050101','BASU050101','BASU050102','BASU050103','BEGF750101','BEGF750102','BEGF750103','BHAR880101','BIGC670101','BIOV880101','BIOV880102','BLAM930101','BLAS910101','BROC820101','BROC820102','BULH740101','BULH740102','BUNA790101','BUNA790102','BUNA790103','BURA740101','BURA740102','CASG920101','CEDJ970101','CEDJ970102','CEDJ970103','CEDJ970104','CEDJ970105','CHAM810101','CHAM820101','CHAM820102','CHAM830101','CHAM830102','CHAM830103','CHAM830104','CHAM830105','CHAM830106','CHAM830107','CHAM830108','CHOC750101','CHOC760101','CHOC760102','CHOC760103','CHOC760104','CHOP780101','CHOP780201','CHOP780202','CHOP780203','CHOP780204','CHOP780205','CHOP780206','CHOP780207','CHOP780208','CHOP780209','CHOP780210','CHOP780211','CHOP780212','CHOP780213','CHOP780214','CHOP780215','CHOP780216','CIDH920101','CIDH920102','CIDH920103','CIDH920104','CIDH920105','COHE430101','CORJ870101','CORJ870102','CORJ870103','CORJ870104','CORJ870105','CORJ870106','CORJ870107','CORJ870108','COSI940101','COWR900101','CRAJ730101','CRAJ730102','CRAJ730103','DAWD720101','DAYM780101','DAYM780201','DESM900101','DESM900102','DIGM050101','EISD840101','EISD860101','EISD860102','EISD860103','ENGD860101','FASG760101','FASG760102','FASG760103','FASG760104','FASG760105','FASG890101','FAUJ830101','FAUJ880101','FAUJ880102','FAUJ880103','FAUJ880104','FAUJ880105','FAUJ880106','FAUJ880107','FAUJ880108','FAUJ880109','FAUJ880110','FAUJ880111','FAUJ880112','FAUJ880113','FINA770101','FINA910101','FINA910102','FINA910103','FINA910104','FODM020101','FUKS010101','FUKS010102','FUKS010103','FUKS010104','FUKS010105','FUKS010106','FUKS010107','FUKS010108','FUKS010109','FUKS010110','FUKS010111','FUKS010112','GARJ730101','GEIM800101','GEIM800102','GEIM800103','GEIM800104','GEIM800105','GEIM800106','GEIM800107','GEIM800108','GEIM800109','GEIM800110','GEIM800111','GEOR030101','GEOR030102','GEOR030103','GEOR030104','GEOR030105','GEOR030106','GEOR030107','GEOR030108','GEOR030109','GOLD730101','GOLD730102','GRAR740101','GRAR740102','GRAR740103','GUOD860101','GUYH850101','GUYH850102','GUYH850104','GUYH850105','HARY940101','HOPA770101','HOPT810101','HUTJ700101','HUTJ700102','HUTJ700103','ISOY800101','ISOY800102','ISOY800103','ISOY800104','ISOY800105','ISOY800106','ISOY800107','ISOY800108','JACR890101','JANJ780101','JANJ780102','JANJ780103','JANJ790101','JANJ790102','JOND750101','JOND750102','JOND920101','JOND920102','JUKT750101','JUNJ780101','JURD980101','KANM800101','KANM800102','KANM800103','KANM800104','KARP850101','KARP850102','KARP850103','KARS160101','KARS160102','KARS160103','KARS160104','KARS160105','KARS160106','KARS160107','KARS160108','KARS160109','KARS160110','KARS160111','KARS160112','KARS160113','KARS160114','KARS160115','KARS160116','KARS160117','KARS160118','KARS160119','KARS160120','KARS160121','KARS160122','KHAG800101','KIDA850101','KIMC930101','KLEP840101','KOEP990101','KOEP990102','KRIW710101','KRIW790101','KRIW790102','KRIW790103','KUHL950101','KUMS000101','KUMS000102','KUMS000103','KUMS000104','KYTJ820101','LAWE840101','LEVM760101','LEVM760102','LEVM760103','LEVM760104','LEVM760105','LEVM760106','LEVM760107','LEVM780101','LEVM780102','LEVM780103','LEVM780104','LEVM780105','LEVM780106','LEWP710101','LIFS790101','LIFS790102','LIFS790103','MANP780101','MAXF760101','MAXF760102','MAXF760103','MAXF760104','MAXF760105','MAXF760106','MCMT640101','MEEJ800101','MEEJ800102','MEEJ810101','MEEJ810102','MEIH800101','MEIH800102','MEIH800103','MITS020101','MIYS850101','MIYS990101','MIYS990102','MIYS990103','MIYS990104','MIYS990105','MONM990101','MONM990201','MUNV940101','MUNV940102','MUNV940103','MUNV940104','MUNV940105','NADH010101','NADH010102','NADH010103','NADH010104','NADH010105','NADH010106','NADH010107','NAGK730101','NAGK730102','NAGK730103','NAKH900101','NAKH900102','NAKH900103','NAKH900104','NAKH900105','NAKH900106','NAKH900107','NAKH900108','NAKH900109','NAKH900110','NAKH900111','NAKH900112','NAKH900113','NAKH920101','NAKH920102','NAKH920103','NAKH920104','NAKH920105','NAKH920106','NAKH920107','NAKH920108','NISK800101','NISK860101','NOZY710101','OLSK800101','ONEK900101','ONEK900102','OOBM770101','OOBM770102','OOBM770103','OOBM770104','OOBM770105','OOBM850101','OOBM850102','OOBM850103','OOBM850104','OOBM850105','PALJ810101','PALJ810102','PALJ810103','PALJ810104','PALJ810105','PALJ810106','PALJ810107','PALJ810108','PALJ810109','PALJ810110','PALJ810111','PALJ810112','PALJ810113','PALJ810114','PALJ810115','PALJ810116','PARJ860101','PARS000101','PARS000102','PLIV810101','PONJ960101','PONP800101','PONP800102','PONP800103','PONP800104','PONP800105','PONP800106','PONP800107','PONP800108','PONP930101','PRAM820101','PRAM820102','PRAM820103','PRAM900101','PRAM900102','PRAM900103','PRAM900104','PTIO830101','PTIO830102','PUNT030101','PUNT030102','QIAN880101','QIAN880102','QIAN880103','QIAN880104','QIAN880105','QIAN880106','QIAN880107','QIAN880108','QIAN880109','QIAN880110','QIAN880111','QIAN880112','QIAN880113','QIAN880114','QIAN880115','QIAN880116','QIAN880117','QIAN880118','QIAN880119','QIAN880120','QIAN880121','QIAN880122','QIAN880123','QIAN880124','QIAN880125','QIAN880126','QIAN880127','QIAN880128','QIAN880129','QIAN880130','QIAN880131','QIAN880132','QIAN880133','QIAN880134','QIAN880135','QIAN880136','QIAN880137','QIAN880138','QIAN880139','RACS770101','RACS770102','RACS770103','RACS820101','RACS820102','RACS820103','RACS820104','RACS820105','RACS820106','RACS820107','RACS820108','RACS820109','RACS820110','RACS820111','RACS820112','RACS820113','RACS820114','RADA880101','RADA880102','RADA880103','RADA880104','RADA880105','RADA880106','RADA880107','RADA880108','RICJ880101','RICJ880102','RICJ880103','RICJ880104','RICJ880105','RICJ880106','RICJ880107','RICJ880108','RICJ880109','RICJ880110','RICJ880111','RICJ880112','RICJ880113','RICJ880114','RICJ880115','RICJ880116','RICJ880117','ROBB760101','ROBB760102','ROBB760103','ROBB760104','ROBB760105','ROBB760106','ROBB760107','ROBB760108','ROBB760109','ROBB760110','ROBB760111','ROBB760112','ROBB760113','ROBB790101','ROSG850101','ROSG850102','ROSM880101','ROSM880102','ROSM880103','SIMZ760101','SNEP660101','SNEP660102','SNEP660103','SNEP660104','SUEM840101','SUEM840102','SUYM030101','SWER830101','TAKK010101','TANS770101','TANS770102','TANS770103','TANS770104','TANS770105','TANS770106','TANS770107','TANS770108','TANS770109','TANS770110','TSAJ990101','TSAJ990102','VASM830101','VASM830102','VASM830103','VELV850101','VENT840101','VHEG790101','VINM940101','VINM940102','VINM940103','VINM940104','WARP780101','WEBA780101','WERD780101','WERD780102','WERD780103','WERD780104','WILM950101','WILM950102','WILM950103','WILM950104','WIMW960101','WOEC730101','WOLR790101','WOLR810101','WOLS870101','WOLS870102','WOLS870103','YUTK870101','YUTK870102','YUTK870103','YUTK870104','ZASB820101','ZHOH040101','ZHOH040102','ZHOH040103','ZIMJ680101','ZIMJ680102','ZIMJ680103','ZIMJ680104','ZIMJ680105']
    file1 = split(file,n)
    file1.to_csv('sam_input.csv', index=None, header=False)
    aai_bin('sam_input.csv','tempfile_out')
    ff1 = open(out,'w')
    sys.stdout=ff1
    aa = []
    for i in file1[0]:
        aa.append(len(i))
    uu = []
    for i in range(0,len(aa),n):
        uu.append(aa[i:i+n])
    for i in range(1,n+1):
        kk = max(uu)[i-1]
        for j in range(1,kk+1):
            for k in std_3:
                print(k+str(j)+'_s'+str(i), end=",")
    print("")
    with open("tempfile_out","r") as f:
        fob = f.readlines()
        fob_1 = fob[1:]
    for each in range(0,len(fob_1),n):
        print(','.join(fob_1[each:each+n]).replace(",\n,",",").replace("\n",""))
    ff1.truncate()
    os.remove('sam_input.csv')
    os.remove('tempfile_out')

##################Parts of Seqeunces#########################
def nt(file,n):
    filename, file_extension = os.path.splitext(file)
    df1 = pd.read_csv(file, header = None)
    df2 = pd.DataFrame(df1[0].str.upper())
    df3 = []
    for i in range(0,len(df2)):
        df3.append(df2[0][i][0:n])
        df4 = pd.DataFrame(df3)
        #df4.to_csv(filename+".nt", index = None, header = False, encoding = 'utf-8')
    for i in range(0,len(df4)):
        ss = len(df4[0][i])
        if ss < n:
            print('\nSequence number',i+1,'has length of',ss,'which is less than the provided value of N-terminal, that is',n,'. Kindly check the sequences.')
            os.remove(file_output)
            sys.exit()
    return df4
def ct(file,n):
    filename, file_extension = os.path.splitext(file)
    df1 = pd.read_csv(file, header = None)
    df2 = pd.DataFrame(df1[0].str.upper())
    df3 = []
    for i in range(0,len(df2)):
        df3.append(df2[0][i][-n:])
        df4 = pd.DataFrame(df3)
        #df4.to_csv(filename+".ct", index = None, header = False, encoding = 'utf-8')
    for i in range(0,len(df4)):
        ss = len(df4[0][i])
        if ss < n:
            print('\nSequence number',i+1,'has length of',ss,'which is less than the provided value of C-terminal, that is',n,'. Kindly check the sequences.')
            os.remove(file_output)
            sys.exit()
    return df4
def rest(file,n,c):
    filename, file_extension = os.path.splitext(file)
    df1 = pd.read_csv(file, header = None)
    df2 = pd.DataFrame(df1[0].str.upper())
    df3 = []
    for i in range(0,len(df2)):
        if c == 0:
            df3.append(df2[0][i][n:])
        else:
            df3.append(df2[0][i][n:-c])
        df4 = pd.DataFrame(df3)
    for i in range(0,len(df4)):
        ss = len(df4[0][i])
        if ss == 0:
            print('\nSequence number',i+1,'has length of',ss,'after removing provided N- and C-terminal residues, that is',str(n)+','+str(c),'. Kindly check the sequences.')
            os.remove(file_output)
            sys.exit()
        #df4.to_csv(filename+".rest", index = None, header = False, encoding = 'utf-8')
    return df4
def restnc(file,n):
    df1 = pd.read_csv(file, header = None)
    df2 = pd.DataFrame(df1[0].str.upper())
    df3 = []
    for i in range(0,len(df2)):
        if n == 0:
            df3.append(df2[0][i][n:])
        else:
            df3.append(df2[0][i][n:-n])
    df4 = pd.DataFrame(df3)
    df4 = pd.DataFrame(df3)
    for i in range(0,len(df4)):
        ss = len(df4[0][i])
        if ss == 0:
            print('\nSequence number',i+1,'has length of',ss,'after removing provided',str(n),' residues from N- and C-terminal. Kindly check the sequences.')
            os.remove(file_output)
            sys.exit()
        #df4.to_csv(filename+".rest", index = None, header = False, encoding = 'utf-8')
    return df4
def nct(file,n):
    filename, file_extension = os.path.splitext(file)
    df1 = pd.read_csv(file, header = None)
    df2 = pd.DataFrame(df1[0].str.upper())
    df3 = []
    for i in range(0,len(df2)):
        df3.append(df2[0][i][:n]+df2[0][i][::-1][:n])
        df4 = pd.DataFrame(df3)
        #df4.to_csv(filename+".ct", index = None, header = False, encoding = 'utf-8')
    for i in range(0,len(df4)):
        ss = len(df4[0][i])
        if ss/2 < n:
            print('\nSequence number',i+1,'has length of',int(ss/2),'which is less than the provided value of N- and C-terminal, that is',n,'. Kindly check the sequences.')
            os.remove(file_output)
            sys.exit()
    return df4
def split(file,v):
    filename, file_extension = os.path.splitext(file)
    df1 = pd.read_csv(file, header = None)
    df2 = pd.DataFrame(df1[0].str.upper())
    for i in range(0,len(df2)):
        ss = len(df2[0][i])
        if ss == 0:
            print('\nSequence number',i+1,'has length of',ss,'. Hence, the number of splits should be between 2 to',ss,'. Kindly provide number of splits in the suggested range.')
            os.remove(file_output)
            sys.exit()
    k1 = []
    for e in range(0,len(df2)):
        s = 0
        k2 = []
        r = 0
        if len(df2[0][e])%v == 0:
            k2.extend(repeat(int(len(df2[0][e])/v),v))
        else:
            r = int(len(df2[0][e])%v)
            k2.extend(repeat(int(len(df2[0][e])/v),v-1))
            k2.append((int(len(df2[0][e])/v))+r)
        for j in k2:
            df3 = df2[0][e][s:j+s]
            k1.append(df3)
            s = j+s
    df4 = pd.DataFrame(k1)
    #df4.to_csv(filename+".split", index = None, header = False, encoding = 'utf-8')
    return df4
####################################File reading###################################
def readseq(file,out):
    with open(file) as f:
        records = f.read()
    records = records.split('>')[1:]
    seqid = []
    seq = []
    for fasta in records:
        array = fasta.split('\n')
        name, sequence = array[0].split()[0], re.sub('[^ARNDCQEGHILKMFPSTWYV-]', '', ''.join(array[1:]).upper())
        seqid.append(name)
        seq.append(sequence)
    if len(seqid) == 0:
        f=open(file,"r")
        data1 = f.readlines()
        for each in data1:
            seq.append(each.replace('\n',''))
        for i in range (1,len(seq)+1):
            seqid.append("Seq_"+str(i))
    for i in seq:
        if 'B' in i:
            print('\nError: The input sequences contain non-natural amino acids. Kindly check the sequence.\n')
            sys.exit()
        if 'J' in i:
            print('\nError: The input sequences contain non-natural amino acids. Kindly check the sequence.\n')
            sys.exit()
        if 'O' in i:
            print('\nError: The input sequences contain non-natural amino acids. Kindly check the sequence.\n')
            sys.exit()
        if 'U' in i:
            print('\nError: The input sequences contain non-natural amino acids. Kindly check the sequence.\n')
            sys.exit()
        if 'Z' in i:
            print('\nError: The input sequences contain non-natural amino acids. Kindly check the sequence.\n')
            sys.exit()
        if 'X' in i:
            print('\nError: The input sequences contain non-natural amino acids. Kindly check the sequence.\n')
            sys.exit()
    df4 = pd.DataFrame(seq)
    df4.to_csv(out,index=None,header=False)
##############################################################################
#Seqeunce file
Sequence_1 = args.input
file_output = str(uuid.uuid4())
readseq(Sequence_1,file_output) 
Sequence = file_output
seq = file_output
#Function to be called
if args.job == None:
    Job = 'AAB'
else:
    Job = args.job
#Number of residue from N-terminal
if args.n_terminal == None:
    nter = int(0)
else:
    nter = int(args.n_terminal)
#Number of residues from C-terminal
if args.c_terminal == None:
    cter = int(0)
else:
    cter = int(args.c_terminal)
#Number of residues from C-terminal
if args.nc_terminal == None:
    ncter = int(0)
else:
    ncter = int(args.nc_terminal)
#Number of residues removed from N-terminal
if args.rest_n == None:
    nrest = int(0)
else:
    nrest=int(args.rest_n)
#Number of residues removed from C-terminal
if args.rest_c == None:
    crest = int(0)
else:
    crest=int(args.rest_c)
#Number of residues after removing residues from N- and  C-terminal
if args.rest_nc == None:
    ncrest = int(0)
else:
    ncrest=int(args.rest_nc)
#Number of splits a sequence is divided into
if args.split == None:
    sp = int(0)
else:
    sp = int(args.split)
#Lambda/gap/lag
if args.lag == None:
    lg = int(1)
else:
    lg = int(args.lag)
#Output_file
if args.output == None:
    result_filename= "pfeature_result.csv"
else:
    result_filename = args.output

if (nter == 0) and (cter == 0) and (nrest == 0) and (crest == 0) and (sp == 0) and (ncter == 0) and (ncrest == 0):
    print('Summary of Parameters:''\n')
    print('Input File:',Sequence_1,'; Job:', Job,'; Output File:',result_filename,)
if nter != 0:
    print('Summary of Parameters:''\n')
    print('Input File:',Sequence_1,'; Job:', Job,'; N-terminal:',nter,'; Output File:',result_filename,)
if cter != 0:
    print('Summary of Parameters:''\n')
    print('Input File:',Sequence_1,'; Job:', Job,'; C-terminal:',cter,'; Output File:',result_filename,)
if ncter != 0:
    print('Summary of Parameters:''\n')
    print('Input File:',Sequence_1,'; Job:', Job,'; NC-terminal:',ncter,'; Output File:',result_filename,)
if nrest != 0 or crest != 0:
    print('Summary of Parameters:''\n')
    print('Input File:',Sequence_1,'; Job:', Job,'; Rest:',(nrest,crest),'; Output File:',result_filename,)
if ncrest != 0 :
    print('Summary of Parameters:''\n')
    print('Input File:',Sequence_1,'; Job:', Job,'; NCRest:',ncrest,'; Output File:',result_filename,)
if sp != 0:
    print('Summary of Parameters:''\n')
    print('Input File:',Sequence_1,'; Job:', Job,'; Number of Split:',sp,'; Output File:',result_filename,)
if Job == 'AAB' or Job == 'ALLBIN':
    if (nter == 0) and (cter == 0) and (nrest == 0) and (crest == 0) and (sp == 0) and (ncter == 0) and (ncrest == 0):
        aab(seq,'tempfile_out')
        df = pd.read_csv('tempfile_out')
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None) 
        df1 = df.dropna(axis="columns", how="any")
        df1.to_csv('sam_allbin.aab',index=None)
        os.remove('tempfile_out')
    if nter != 0:
        file1 = nt(Sequence,nter)
        file1.to_csv('sam_input.csv', index=None, header=False)
        aab('sam_input.csv','tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'N'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        df1 = df.dropna(axis="columns", how="any")
        df1.to_csv('sam_allbin.aab_nt',index=None)
        os.remove('tempfile_out')
        os.remove('sam_input.csv')
    if cter != 0:
        file1 = ct(Sequence,cter)
        file1.to_csv('sam_input.csv', index=None, header=False)
        aab('sam_input.csv','tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'C'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        df1 = df.dropna(axis="columns", how="any")
        df1.to_csv('sam_allbin.aab_ct',index=None)
        os.remove('tempfile_out')
        os.remove('sam_input.csv')
    if nrest != 0 or crest != 0:
        file1 = rest(Sequence,nrest,crest)
        file1.to_csv('sam_input.csv', index=None, header=False)
        aab('sam_input.csv','tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'R'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        df1 = df.dropna(axis="columns", how="any")
        df1.to_csv('sam_allbin.aab_rt',index=None)
        os.remove('tempfile_out')
        os.remove('sam_input.csv')
    if ncrest != 0:
        file1 = restnc(Sequence,ncrest)
        file1.to_csv('sam_input.csv', index=None, header=False)
        aab('sam_input.csv','tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'RNC'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        df1 = df.dropna(axis="columns", how="any")
        df1.to_csv('sam_allbin.aab_rnc',index=None)
        os.remove('tempfile_out')
        os.remove('sam_input.csv')
    if ncter != 0:
        file1 = nct(Sequence,ncter)
        file1.to_csv('sam_input.csv', index=None, header=False)
        aab('sam_input.csv','tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'NC'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        df1 = df.dropna(axis="columns", how="any")
        df1.to_csv('sam_allbin.aab_nct',index=None)
        os.remove('tempfile_out')
        os.remove('sam_input.csv')
    if sp != 0:
        aab_split(seq,sp,'temp_out')
        df = pd.read_csv('temp_out')
        df2 = df.iloc[:,:-1].fillna('NA')        
        df2.to_csv(result_filename,index=None)
        df2.to_csv('sam_allbin.aab_st',index=None)
        os.remove('temp_out')
if Job == 'DPB' or Job == 'ALLBIN':
    if (nter == 0) and (cter == 0) and (nrest == 0) and (crest == 0) and (sp == 0) and (ncter == 0) and (ncrest == 0):
        bin_di(seq,lg,'tempfile_out')
        df = pd.read_csv('tempfile_out')
        print('Order of Dipeptide:',lg,'\n')
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        df1 = df.dropna(axis="columns", how="any")
        df1.to_csv('sam_allbin.dpb',index=None)
        os.remove('tempfile_out')
    if nter != 0:
        file1 = nt(Sequence,nter)
        print('Order of Dipeptide:',lg,'\n')
        file1.to_csv('sam_input.csv', index=None, header=False)
        bin_di('sam_input.csv',lg,'tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'N'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        df1 = df.dropna(axis="columns", how="any")
        df1.to_csv('sam_allbin.dpb_nt',index=None)
        os.remove('sam_input.csv')
        os.remove('tempfile_out')
    if cter != 0:
        file1 = ct(Sequence,cter)
        print('Order of Dipeptide:',lg,'\n')
        file1.to_csv('sam_input.csv', index=None, header=False)
        bin_di('sam_input.csv',lg,'tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'C'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        df1 = df.dropna(axis="columns", how="any")
        df1.to_csv('sam_allbin.dpb_ct',index=None)
        os.remove('sam_input.csv')
        os.remove('tempfile_out')
    if nrest != 0 or crest != 0:
        file1 = rest(Sequence,nrest,crest)
        print('Order of Dipeptide:',lg,'\n')
        file1.to_csv('sam_input.csv', index=None, header=False)
        bin_di('sam_input.csv',lg,'tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'R'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        df1 = df.dropna(axis="columns", how="any")
        df1.to_csv('sam_allbin.dpb_rt',index=None)
        os.remove('sam_input.csv')
        os.remove('tempfile_out')
    if ncrest != 0:
        file1 = restnc(Sequence,ncrest)
        print('Order of Dipeptide:',lg,'\n')
        file1.to_csv('sam_input.csv', index=None, header=False)
        bin_di('sam_input.csv',lg,'tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'RNC'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        df1 = df.dropna(axis="columns", how="any")
        df1.to_csv('sam_allbin.dpb_rnc',index=None)
        os.remove('sam_input.csv')
        os.remove('tempfile_out')
    if ncter != 0:
        file1 = nct(Sequence,ncter)
        print('Order of Dipeptide:',lg,'\n')
        file1.to_csv('sam_input.csv', index=None, header=False)
        bin_di('sam_input.csv',lg,'tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'NC'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        df1 = df.dropna(axis="columns", how="any")
        df1.to_csv('sam_allbin.dpb_nct',index=None)
        os.remove('sam_input.csv')
        os.remove('tempfile_out')
    if sp != 0:
        print('Order of Dipeptide:',lg,'\n')
        dpb_split(seq,sp,lg,'temp_out')
        df = pd.read_csv('temp_out')
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        df2.to_csv('sam_allbin.dpb_st',index=None)
        os.remove('temp_out')

if Job == 'ATB' or Job == 'ALLBIN':
    if (nter == 0) and (cter == 0) and (nrest == 0) and (crest == 0) and (sp == 0) and (ncter == 0) and (ncrest == 0):
        atom_bin(seq,'tempfile_out')
        df = pd.read_csv('tempfile_out')
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        os.remove('tempfile_out')
    if nter != 0:
        file1 = nt(Sequence,nter)
        file1.to_csv('sam_input.csv', index=None, header=False)
        atom_bin('sam_input.csv','tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'N'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        os.remove('tempfile_out')
        os.remove('sam_input.csv')
    if cter != 0:
        file1 = ct(Sequence,cter)
        file1.to_csv('sam_input.csv', index=None, header=False)
        atom_bin('sam_input.csv','tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'C'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        os.remove('tempfile_out')
        os.remove('sam_input.csv')
    if nrest != 0 or crest != 0:
        file1 = rest(Sequence,nrest,crest)
        file1.to_csv('sam_input.csv', index=None, header=False)
        atom_bin('sam_input.csv','tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'R'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        os.remove('tempfile_out')
        os.remove('sam_input.csv')
    if ncrest != 0:
        file1 = restnc(Sequence,ncrest)
        file1.to_csv('sam_input.csv', index=None, header=False)
        atom_bin('sam_input.csv','tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'RNC'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        os.remove('tempfile_out')
        os.remove('sam_input.csv')
    if ncter != 0:
        file1 = nct(Sequence,ncter)
        file1.to_csv('sam_input.csv', index=None, header=False)
        atom_bin('sam_input.csv','tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'NC'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        os.remove('tempfile_out')
        os.remove('sam_input.csv')
    if sp != 0:
        atb_split(seq,sp,'temp_out')
        df = pd.read_csv('temp_out')
        df2 = df.dropna(axis=1, how='all')
        df2 = df2.fillna('NA')
        df2.to_csv(result_filename,index=None)
        os.remove('temp_out')
if Job == 'BTB' or Job == 'ALLBIN':
    if (nter == 0) and (cter == 0) and (nrest == 0) and (crest == 0) and (sp == 0) and (ncter == 0) and (ncrest == 0):
        bond_bin(seq,'tempfile_out')
        df = pd.read_csv('tempfile_out')
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        os.remove('tempfile_out')
    if nter != 0:
        file1 = nt(Sequence,nter)
        file1.to_csv('sam_input.csv', index=None, header=False)
        bond_bin('sam_input.csv','tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'N'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        os.remove('tempfile_out')
        os.remove('sam_input.csv')
    if cter != 0:
        file1 = ct(Sequence,cter)
        file1.to_csv('sam_input.csv', index=None, header=False)
        bond_bin('sam_input.csv','tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'C'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        os.remove('tempfile_out')
        os.remove('sam_input.csv')
    if nrest != 0 or crest != 0:
        file1 = rest(Sequence,nrest,crest)
        file1.to_csv('sam_input.csv', index=None, header=False)
        bond_bin('sam_input.csv','tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'R'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        os.remove('tempfile_out')
        os.remove('sam_input.csv')
    if ncrest != 0:
        file1 = restnc(Sequence,ncrest)
        file1.to_csv('sam_input.csv', index=None, header=False)
        bond_bin('sam_input.csv','tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'RNC'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        os.remove('tempfile_out')
        os.remove('sam_input.csv')
    if ncter != 0:
        file1 = nct(Sequence,ncter)
        file1.to_csv('sam_input.csv', index=None, header=False)
        bond_bin('sam_input.csv','tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'NC'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        os.remove('tempfile_out')
        os.remove('sam_input.csv')
    if sp != 0:
        btb_split(seq,sp,'temp_out')
        df = pd.read_csv('temp_out')
        df2 = df.dropna(axis=1, how='all')
        df2 = df2.fillna('NA')
        df2.to_csv(result_filename,index=None)
        os.remove('temp_out')
if Job == 'PCB' or Job == 'ALLBIN':
    if (nter == 0) and (cter == 0) and (nrest == 0) and (crest == 0) and (sp == 0) and (ncter == 0) and (ncrest == 0):
        pcp_bin(seq,'tempfile_out')
        df = pd.read_csv('tempfile_out')
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        df1 = df.dropna(axis="columns", how="any")
        df1.to_csv('sam_allbin.pcb',index=None)
        os.remove('tempfile_out')
    if nter != 0:
        file1 = nt(Sequence,nter)
        file1.to_csv('sam_input.csv', index=None, header=False)
        pcp_bin('sam_input.csv','tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'N'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        df1 = df.dropna(axis="columns", how="any")
        df1.to_csv('sam_allbin.pcb_nt',index=None)
        os.remove('tempfile_out')
        os.remove('sam_input.csv')
    if cter != 0:
        file1 = ct(Sequence,cter)
        file1.to_csv('sam_input.csv', index=None, header=False)
        pcp_bin('sam_input.csv','tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'C'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        df1 = df.dropna(axis="columns", how="any")
        df1.to_csv('sam_allbin.pcb_ct',index=None)
        os.remove('tempfile_out')
        os.remove('sam_input.csv')
    if nrest != 0 or crest != 0:
        file1 = rest(Sequence,nrest,crest)
        file1.to_csv('sam_input.csv', index=None, header=False)
        pcp_bin('sam_input.csv','tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'R'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        df1 = df.dropna(axis="columns", how="any")
        df1.to_csv('sam_allbin.pcb_rt',index=None)
        os.remove('tempfile_out')
        os.remove('sam_input.csv')
    if ncrest != 0:
        file1 = restnc(Sequence,ncrest)
        file1.to_csv('sam_input.csv', index=None, header=False)
        pcp_bin('sam_input.csv','tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'RNC'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        df1 = df.dropna(axis="columns", how="any")
        df1.to_csv('sam_allbin.pcb_rnc',index=None)
        os.remove('tempfile_out')
        os.remove('sam_input.csv')
    if ncter != 0:
        file1 = nct(Sequence,ncter)
        file1.to_csv('sam_input.csv', index=None, header=False)
        pcp_bin('sam_input.csv','tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'NC'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        df1 = df.dropna(axis="columns", how="any")
        df1.to_csv('sam_allbin.pcb_nct',index=None)
        os.remove('tempfile_out')
        os.remove('sam_input.csv')
    if sp != 0:
        pcb_split(seq,sp,'temp_out')
        df = pd.read_csv('temp_out')
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        df2.to_csv('sam_allbin.pcb_st',index=None)
        os.remove('temp_out')
if Job == 'AIB' or Job == 'ALLBIN':
    if (nter == 0) and (cter == 0) and (nrest == 0) and (crest == 0) and (sp == 0) and (ncter == 0) and (ncrest == 0):
        aai_bin(seq,'tempfile_out')
        df = pd.read_csv('tempfile_out')
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        df1 = df.dropna(axis="columns", how="any")
        df1.to_csv('sam_allbin.aib',index=None)
        os.remove('tempfile_out')
    if nter != 0:
        file1 = nt(Sequence,nter)
        file1.to_csv('sam_input.csv', index=None, header=False)
        aai_bin('sam_input.csv','tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'N'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        df1 = df.dropna(axis="columns", how="any")
        df1.to_csv('sam_allbin.aib_nt',index=None)
        os.remove('tempfile_out')
        os.remove('sam_input.csv')
    if cter != 0:
        file1 = ct(Sequence,cter)
        file1.to_csv('sam_input.csv', index=None, header=False)
        aai_bin('sam_input.csv','tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'C'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        df1 = df.dropna(axis="columns", how="any")
        df1.to_csv('sam_allbin.aib_ct',index=None)
        os.remove('tempfile_out')
        os.remove('sam_input.csv')
    if nrest != 0 or crest != 0:
        file1 = rest(Sequence,nrest,crest)
        file1.to_csv('sam_input.csv', index=None, header=False)
        aai_bin('sam_input.csv','tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'R'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        df1 = df.dropna(axis="columns", how="any")
        df1.to_csv('sam_allbin.aib_rt',index=None)
        os.remove('tempfile_out')
        os.remove('sam_input.csv')
    if ncrest != 0:
        file1 = restnc(Sequence,ncrest)
        file1.to_csv('sam_input.csv', index=None, header=False)
        aai_bin('sam_input.csv','tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'RNC'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        df1 = df.dropna(axis="columns", how="any")
        df1.to_csv('sam_allbin.aib_rnc',index=None)
        os.remove('tempfile_out')
        os.remove('sam_input.csv')
    if ncter != 0:
        file1 = nct(Sequence,ncter)
        file1.to_csv('sam_input.csv', index=None, header=False)
        aai_bin('sam_input.csv','tempfile_out')
        df = pd.read_csv('tempfile_out')
        df.columns = 'NC'+df.columns
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        df1 = df.dropna(axis="columns", how="any")
        df1.to_csv('sam_allbin.aib_nct',index=None)
        os.remove('tempfile_out')
        os.remove('sam_input.csv')
    if sp != 0:
        aib_split(seq,sp,'temp_out')
        df = pd.read_csv('temp_out')
        df2 = df.iloc[:,:-1].fillna('NA')
        df2.to_csv(result_filename,index=None)
        df2.to_csv('sam_allbin.aib_st',index=None)
        os.remove('temp_out')

if Job == 'ALLBIN':
    if (nter == 0) and (cter == 0) and (nrest == 0) and (crest == 0) and (sp == 0) and (ncter == 0) and (ncrest == 0):
        df1 = pd.read_csv("sam_allbin.aab")
        df2 = pd.read_csv("sam_allbin.dpb")
        df3 = pd.read_csv("sam_allbin.pcb")
        df4 = pd.read_csv("sam_allbin.aib")
        df19 = pd.concat([df1,df2,df3,df4],axis=1)
        df19.to_csv(result_filename, index=None)
    if nter != 0:
        df1 = pd.read_csv("sam_allbin.aab_nt")
        df2 = pd.read_csv("sam_allbin.dpb_nt")
        df3 = pd.read_csv("sam_allbin.pcb_nt")
        df4 = pd.read_csv("sam_allbin.aib_nt")
        df19 = pd.concat([df1,df2,df3,df4],axis=1)
        df19.to_csv(result_filename, index=None)
    if cter != 0:
        df1 = pd.read_csv("sam_allbin.aab_ct")
        df2 = pd.read_csv("sam_allbin.dpb_ct")
        df3 = pd.read_csv("sam_allbin.pcb_ct")
        df4 = pd.read_csv("sam_allbin.aib_ct")
        df19 = pd.concat([df1,df2,df3,df4],axis=1)
        df19.to_csv(result_filename, index=None)
    if nrest != 0 or crest != 0:
        df1 = pd.read_csv("sam_allbin.aab_rt")
        df2 = pd.read_csv("sam_allbin.dpb_rt")
        df3 = pd.read_csv("sam_allbin.pcb_rt")
        df4 = pd.read_csv("sam_allbin.aib_rt")
        df19 = pd.concat([df1,df2,df3,df4],axis=1)
        df19.to_csv(result_filename, index=None)
    if ncrest != 0:
        df1 = pd.read_csv("sam_allbin.aab_rnc")
        df2 = pd.read_csv("sam_allbin.dpb_rnc")
        df3 = pd.read_csv("sam_allbin.pcb_rnc")
        df4 = pd.read_csv("sam_allbin.aib_rnc")
        df19 = pd.concat([df1,df2,df3,df4],axis=1)
        df19.to_csv(result_filename, index=None)
    if ncter != 0:
        df1 = pd.read_csv("sam_allbin.aab_nct")
        df2 = pd.read_csv("sam_allbin.dpb_nct")
        df3 = pd.read_csv("sam_allbin.pcb_nct")
        df4 = pd.read_csv("sam_allbin.aib_nct")
        df19 = pd.concat([df1,df2,df3,df4],axis=1)
        df19.to_csv(result_filename, index=None)
    if sp != 0:
        df1 = pd.read_csv("sam_allbin.aab_st")
        df2 = pd.read_csv("sam_allbin.dpb_st")
        df3 = pd.read_csv("sam_allbin.pcb_st")
        df4 = pd.read_csv("sam_allbin.aib_st")
        df19 = pd.concat([df1,df2,df3,df4],axis=1)
        df19.to_csv(result_filename, index=None)
filelist=glob.glob("sam_allbin*")
for file_2 in filelist:
    os.remove(file_2)
os.remove(file_output)
